using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Data.SqlClient;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class STD_INSTITUTIONDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public STD_INSTITUTIONDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public STD_INSTITUTION GetItemComplete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            STD_INSTITUTION objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_INSTITUTION_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ID).FirstOrDefault();
                    if (objReturn != null)
                    {
                        if (objReturn.STD_FACILITYTYPE_ID > 0)
                            objReturn.STD_FACILITYTYPE = dbContext.usp_STD_FACILITYTYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.STD_FACILITYTYPE_ID).FirstOrDefault();

                        if (objReturn.STREETSTATE_ID != null && objReturn.STREETSTATE_ID.Value > 0)
                            objReturn.STREETSTATE = dbContext.usp_STD_STATE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.STREETSTATE_ID.Value).FirstOrDefault();

                        if (objReturn.VISN_ID != null && objReturn.VISN_ID.Value > 0)
                            objReturn.VISN = dbContext.usp_STD_INSTITUTION_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.VISN_ID.Value).FirstOrDefault();
                    }
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_INSTITUTION> GetFacs(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<STD_INSTITUTION> objReturn = null;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlDataAdapter sAdapter = null;
            DataSet objTemp = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.BCCCR_usp_Get_Fac", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                //sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                //sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);

                objTemp = new DataSet();
                sAdapter = new SqlDataAdapter(sCmd);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                sAdapter.Fill(objTemp);
                LogManager.LogTiming(logDetails);
                CheckDataSet(objTemp);

                if (objTemp != null && objTemp.Tables.Count > 0 && objTemp.Tables[0].Rows.Count > 0)
                {
                    var myData = objTemp.Tables[0].AsEnumerable().Select(r => ParseFacs(r));
                    if (myData != null)
                    {
                        objReturn = myData.ToList<STD_INSTITUTION>();
                    }
                }

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sAdapter != null)
                {
                    sAdapter.Dispose();
                    sAdapter = null;
                }
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public STD_INSTITUTION ParseFacs(DataRow row)
        {
            STD_INSTITUTION objReturn = new STD_INSTITUTION
            {
                FACID = row.Field<int>("FACID"),
                FACTEXT = row.Field<string>("FACTEXT"),
                STA3N = row.Field<string>("STA3N"),
                VISNSID = row.Field<int>("VISNID"),
                VISNTEXT = row.Field<string>("VISNTEXT")
            };

            return objReturn;
        }

        #endregion
    }
}
